﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces-web/WorkSpacesWebRequest.h>
#include <aws/workspaces-web/WorkSpacesWeb_EXPORTS.h>

#include <utility>

namespace Aws {
namespace WorkSpacesWeb {
namespace Model {

/**
 */
class DeleteBrowserSettingsRequest : public WorkSpacesWebRequest {
 public:
  AWS_WORKSPACESWEB_API DeleteBrowserSettingsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteBrowserSettings"; }

  AWS_WORKSPACESWEB_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ARN of the browser settings.</p>
   */
  inline const Aws::String& GetBrowserSettingsArn() const { return m_browserSettingsArn; }
  inline bool BrowserSettingsArnHasBeenSet() const { return m_browserSettingsArnHasBeenSet; }
  template <typename BrowserSettingsArnT = Aws::String>
  void SetBrowserSettingsArn(BrowserSettingsArnT&& value) {
    m_browserSettingsArnHasBeenSet = true;
    m_browserSettingsArn = std::forward<BrowserSettingsArnT>(value);
  }
  template <typename BrowserSettingsArnT = Aws::String>
  DeleteBrowserSettingsRequest& WithBrowserSettingsArn(BrowserSettingsArnT&& value) {
    SetBrowserSettingsArn(std::forward<BrowserSettingsArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_browserSettingsArn;
  bool m_browserSettingsArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpacesWeb
}  // namespace Aws
